Option Explicit
Const scriptName = "Extend Overflowed Text Flow"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - July 26, 2002 - MJM - Inital version.



' Script constants, questions, and error messages.
Const errNoOverflowedText = "The active text flow isn't overflowed, so no extending is necessary."
Const errNoActiveTextFlow = "This script requires an active text flow."
Const errSwitchSpreads = "Please switch to the spread containing the blocks you want to extend."
Const errNoMasterSpreads = "This script can't extend a text flow on a master spread."
Const errNoTextOnAPath = "This script can't extend text on a path."
Const errNoFlowedTextSingular = "This flow cannot be extended further because the next character or embedded object is larger than the available text block."
Const errNoFlowedTextPlural = "This flow cannot be extended further because the next character or embedded object is larger than the available text blocks."
    
Const sumBlocksPrefix = "Created "
Const sumBlocksOnlyOne = "1 new block "
Const sumBlocksSuffix = " new blocks "
Const sumPagesPrefix = "and "
Const sumPagesOnlyOne = "1 new page."
Const sumPagesSuffix = " new pages."


' Enums

' enum crClass
Const crMasterSpread = 1297313906

' enum crScaleMethod
Const crNoScaling = -2074909844
Const crFitContainer = -2074922426
Const crFitWithinContainer = -2075764925
Const crFillContainer = -2075770001

' enum crLocation
Const crBeforeAll = 1650945639
Const crAfterAll = 1701733408
Const crBefore = 1650812527
Const crAfter = 1634104421


' Utility Functions
Private Function IsTextContainer(ByRef elems)
    Dim returnMe
    Dim anElem
    Dim tempVar
    
    returnMe = False
    
    Err.Clear
    On Error Resume Next
    For Each anElem In elems
        Set tempVar = anElem.TextBlock
        returnMe = returnMe Or (Err.Number <> 0)
        If returnMe Then Exit For
    Next
    On Error GoTo 0
    
    IsTextContainer = returnMe
End Function

Private Function OnMasterSpread(ByRef elems)
    Dim returnMe
    returnMe = False

    Dim anElem
    For Each anElem In elems
        returnMe = returnMe Or (anElem.OwnerSpread.Class = crMasterSpread)
        If Not returnMe Then Exit For
    Next

    OnMasterSpread = returnMe
End Function

Private Function GetElemsFromFlow(ByRef atf)
    Dim elems
    Set elems = WScript.CreateObject("Creator.ElementList")

    Dim parentID, spreadID

    spreadID = CreatorApp.CurrentSpread.ID

    Dim aBlock
    For Each aBlock In atf.TextBlocks
        parentID = aBlock.OwnerShape.Parent.ID
        If parentID = spreadID Then
            elems.Add(aBlock.OwnerShape)
        End If
    Next
    
    Set GetElemsFromFlow = elems
End Function

Private Function GetOnSamePage(ByRef elems)
    Dim returnMe
    returnMe = True
    Dim page
    page = elems(1).PageIndex

    Dim anElem 
    For Each anElem In elems
        returnMe = returnMe And (page = anElem.PageIndex)
        If Not returnMe Then Exit For
    Next
        
    GetOnSamePage = returnMe
End Function

Private Function GetHOffset(ByRef elems)
    Dim farLeft, farRight
    farLeft = 9999999
    farRight = -9999999
    Dim bounds
    
    Dim anElem
    For Each anElem In elems
        bounds = anElem.bounds
        If (bounds(0) < farLeft) Then farLeft = bounds(0)
        If (bounds(2) > farRight) Then farRight = bounds(2)
    Next
    
    GetHOffset = (farLeft + farRight) / 2
End Function

Private Function FlowedSomeText(ByRef elems)
    Dim anElem
    Dim returnMe
    returnMe = False
    
    For Each anElem In elems
        returnMe = returnMe Or (anElem.TextBlock.Characters.Count > 0)
        If returnMe Then Exit For
    Next
    
    FlowedSomeText = returnMe
End Function



''''''''''''''''''''''''''''''''''''''''''''''''''
'
'   Main
'
''''''''''''''''''''''''''''''''''''''''''''''''''

Dim continueOn
continueOn = True
Dim showSummary
showSummary = True
        
Dim atf, elems, newElems
Dim onSamePage, facingPages, hadOddPageCount
Dim offsetAmount(1)
    
Dim newBlockCount, newPageCount
Dim leftPageSize, rightPageSize
Dim leftMS, rightMS
Dim startPage, currentPage
Dim activeSpread, docPages

Dim tempForErrorCheck

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Err.Clear
On Error Resume Next
Set atf = CreatorApp.ActiveTextFlow
continueOn = (Err.Number = 0)
If (continueOn) Then
  tempForErrorCheck = atf.Parent.ID
  continueOn = (Err.Number = 0)
End If
On Error GoTo 0


' Sanity check
If continueOn Then
    continueOn = atf.HasOverflowedText
    If Not continueOn Then
        Call MsgBox(errNoOverflowedText, vbOKOnly, scriptName)
        showSummary = False
    End If
Else
    Call MsgBox(errNoActiveTextFlow, vbOKOnly, scriptName)
    showSummary = False
End If

If continueOn Then
    Set docPages = CreatorApp.ActiveDocument.Pages
    facingPages = CreatorApp.ActiveDocument.facingPages
    hadOddPageCount = docPages.Count Mod 2
    Set elems = GetElemsFromFlow(atf)
        
    If elems.Count = 0 Then
        continueOn = False
        Call MsgBox(errSwitchSpreads, vbOKOnly, scriptName)
    ElseIf OnMasterSpread(elems) Then
        continueOn = False
        Call MsgBox(errNoMasterSpreads, vbOKOnly, scriptName)
    ElseIf IsTextContainer(elems) Then
        continueOn = False
        Call MsgBox(errNoTextOnAPath, vbOKOnly, scriptName)
    End If
    showSummary = continueOn
End If
    
If continueOn Then
    onSamePage = GetOnSamePage(elems)
    If facingPages And onSamePage Then
        offsetAmount(0) = 2 * GetHOffset(elems)
    Else
        offsetAmount(0) = 0
    End If
    offsetAmount(1) = 0
        
    If facingPages Then
        If onSamePage Then
            startPage = elems(1).OwnerPage.Index
            leftPageSize = docPages(startPage).Size
            Set leftMS = docPages(startPage).MasterSpread
            rightPageSize = docPages(startPage).Size
            Set rightMS = docPages(startPage).MasterSpread
        Else
            startPage = CreatorApp.CurrentSpread.Pages(2).Index
            leftPageSize = docPages(startPage-1).Size
            Set leftMS = docPages(startPage-1).MasterSpread
            rightPageSize = docPages(startPage).Size
            Set rightMS = docPages(startPage).MasterSpread
        End If
    Else
        startPage = CreatorApp.CurrentSpread.Pages(1).Index
        leftPageSize = CreatorApp.CurrentSpread.Pages(1).Size
        Set leftMS = CreatorApp.CurrentSpread.Pages(1).MasterSpread
    End If
    currentPage = startPage
End If
    
newBlockCount = 0
newPageCount = 0
Do While (continueOn)
    Call docPages.Add(1, leftPageSize, crAfter, currentPage)
    docPages(currentPage + 1).MasterSpread = leftMS
    newPageCount = newPageCount + 1
    currentPage = currentPage + 1
     
    If facingPages And Not onSamePage Then
        Call docPages.Add(1, rightPageSize, crAfter, currentPage)
        docPages(currentPage + 1).MasterSpread = rightMS
        newPageCount = newPageCount + 1
        currentPage = currentPage + 1
    End If
    Set activeSpread = docPages(currentPage).Parent
    CreatorApp.LayoutWindows(1).CurrentSpread = activeSpread
    
    If facingPages And onSamePage Then
        offsetAmount(0) = offsetAmount(0) * -1
        Set newElems = elems.Duplicate(1, 0, 0, True, False, False, crNoScaling, crBeforeAll, activeSpread, offsetAmount)
    Else
        Set newElems = elems.Duplicate(1, 0, 0, True, False, False, crNoScaling, crBeforeAll, activeSpread)
    End If
    
    newBlockCount = newBlockCount + newElems.Count
    Set elems = newElems
   
    continueOn = atf.HasOverflowedText
    If continueOn And Not FlowedSomeText(elems) Then
        continueOn = False
        showSummary = False
        If elems.Count <> 1 Then
            Call MsgBox(errNoFlowedTextPlural, vbOKOnly, scriptName)
        Else
            Call MsgBox(errNoFlowedTextSingular, vbOKOnly, scriptName)
        End If
    End If
        
Loop
    
If (newPageCount > 0) Then
  If facingPages And onSamePage And (docPages.Count Mod 2 <> hadOddPageCount) Then
    ' make one last page to even everything up
    Call docPages.Add(1, leftPageSize, crAfter, currentPage)
    docPages(currentPage + 1).MasterSpread = leftMS
    newPageCount = newPageCount + 1
    currentPage = currentPage + 1
  End If
End If
    
If showSummary Then
    Dim summaryString
    summaryString = sumBlocksPrefix
    If (newBlockCount = 1) Then
        summaryString = summaryString & sumBlocksOnlyOne
    Else
        summaryString = summaryString & newBlockCount & sumBlocksSuffix
    End If
    
    summaryString = summaryString & sumPagesPrefix
    If (newPageCount = 1) Then
        summaryString = summaryString & sumPagesOnlyOne
    Else
        summaryString = summaryString & newPageCount & sumPagesSuffix
    End If
        
    Call MsgBox(summaryString, vbOKOnly, scriptName)
End If
